<?php
/*****************************************************************************
 * Wir binden hier unseren Standard header ein, der alle weiteren Scripte einbindet
 * und das Cachen im Browser abschaltet.
 *****************************************************************************/

require_once("inc/nocache.inc.php");

/*****************************************************************************
 * Da wir immer eine Fehlermeldung in roter Schrift ausgeben wollen, hier eine
 * Funktion, die einen Text ausgibt und das Script danach beendet. Funktionen
 * sollten immer am Anfang der Scripte stehen, am besten in eigenen Dateien und
 * dann per include() bzw. require() einbinden.
 *****************************************************************************/

function printError($txt)
  {
  echo("<font color=\"red\">".$txt."</font>\n</body>\n</html>\n");
  exit;  
  }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//DE" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="en">
<head>
<?php
/*****************************************************************************
 * Wir binden hier unsere Standard metatags ein
 *****************************************************************************/
require_once("inc/metadata.inc.php");
?>
</head>
<body>
<?php
/*****************************************************************************
 * Anzeige der Seiten Navigation (siehe nocache.inc.php fr Funktionsdefinition)
 *****************************************************************************/
printNavigation('Erstellen einer Tabelle','listtable_oci.php','insertdata_oci.php','createtable_oci.php');
?>
Hier wird gezeigt, wie man diverse Queries in einem PHP Script abarbeiten kann.<br>
Ausserdem wird die Verwendung von Bind Variablen demonstriert.<br>
<hr>
<?php
/*****************************************************************************
 * Zuerst muss eine Datenbank Verbindung mit OCILogon() erstellt werden,
 * bei Erfolg gibt die Funktion ein Connection Handle zurck, sonst NULL im
 * Fehlerfall. Wenn eine Remote DB angesprochen werden soll muss als dritter
 * Parameter der TNS Name der DB angegeben werden, sonst wird zu ORACLE_SID
 * connected. Im Fehlerfall wird via printError() ein Fehler ausgegeben und 
 * innerhalb der Funktion auch das Script beendet.
 *****************************************************************************/

$sock = OCILogon("scott","tiger");
if(!$sock)
  {
  printError("Konnte keine Verbindung zur lokalen Datenbank aufbauen!?");
  }

/*****************************************************************************
 * Alle in diesem Script verwendeten Queries:
 *****************************************************************************/

$chkquery   = "SELECT COUNT(TABLE_NAME) AS ANZ FROM USER_TABLES WHERE TABLE_NAME=:tablename";

$createquery=<<<EOM
CREATE TABLE SCOTT_TEST
  (
  ID    NUMBER(38) NOT NULL,
  NAME  VARCHAR2(64)
  )
EOM;

/*****************************************************************************
 * Da wir eine Tabelle erstellen wollen, muss zuerst geprft werden, ob die
 * Tabelle schon vorhanden ist. Ist sie vorhanden, dann droppen wir diese ohne
 * Rckmeldung. Tabellenname ist SCOTT_TEST. 
 * Zuerst parsen wir unseren Test query:
 *****************************************************************************/

if(!($stmt = OCIParse($sock,$chkquery)))
  {
  printError("Konnte Check-Query nicht parsen (QUERY: ".$chkquery.")");
  }

/*****************************************************************************
 * Da wir hier mit Bind Variablen arbeiten wollen, mssen jetzt die gewnschten
 * Variablen "gebunden" werden. Dieses geschieht mit den Funktionen OCIDefineByName()
 * und OCIBindByName(). Dabei ist darauf zu achten das OCIDefineByName() die
 * Feldnamen IMMER in UPPER CASE erwartet, im Gegenzug dazu sind bei OCIBindByName()
 * die Feldnamen case-sensitiv!
 *****************************************************************************/

$tname = "SCOTT_TEST";      // Der Tablename, nach dem wir suchen

//  Der Rckgabe Wert vom Select Statement soll in die Variable $rowcounter
//  von PHP geschrieben werden:

OCIDefineByName($stmt,"ANZ",$rowcounter);   

// Und der Platzhalter :tablename soll den Wert aus $tname bernehmen:

OCIBindByName($stmt,":tablename",$tname,-1);

// Nach dem Bindings knnen wir jetzt das Statement Handle "executen":

if(!OCIExecute($stmt,OCI_DEFAULT))
  {
  OCIFreeStatement($stmt);      // Statement freigeben
  OCILogoff($sock);             // Verbindung beenden
  printError("Konnte Query (".$chkquery.") nicht ausfuehren!");
  }

/*****************************************************************************
 * Jetzt mssen wir die Daten "fetchen". Damit wird pro Aufruf
 * ein Datensatz in die per OCIDefineByName() angegebenen PHP Variablen
 * von OCI geschrieben. Da wir hier nur eine Row haben, wird auch das
 * Fetch logischerweise nur einmal aufgerufen, sonst knnte man das 
 * in einer Schleife laufen lassen, z.b. while(OCIFetch()) { ... }
 *****************************************************************************/

OCIFetch($stmt);          // Das Ergebnis steht jetzt in der Variablen $rowcounter
OCIFreeStatement($stmt);  // Statement Handle freigeben, da nicht mehr gebraucht

if($rowcounter)           // Wenn der $rowcounter != 0 ist, dann existiert die
  {                       // Tabelle und wir machen nichts weiter.
  echo("Die Tabelle ".$tname." existiert bereits im aktuellen Schema!\n<br>\n<br>Aufbau:\n");
  echo("<pre>\n".$createquery."</pre>\n");
  }
else                      // Tabelle existiert nicht, also legen wir die an:
  {
  echo("Tabelle ".$tname." nicht gefunden, lege neue Tabelle mit folgendem Aufbau an:<br>\n");  
  echo("<pre>\n".$createquery."</pre>\n");

  // Zuerst wieder das Parsen des DDL Kommandos:
  
  if(!($stmt = OCIParse($sock,$createquery)))
    {
    OCILogoff($sock);
    printError("Konnte Create Table Query nicht parsen!");
    } 
  // Da wir ein DDL Kommando absetzen brauchen wir keine Binds oder Defines setzen,
  // wir knnen direkt den Query executen:
  
  if(!OCIExecute($stmt,OCI_DEFAULT))
    {
    OCIFreeStatement($stmt);
    OCILogoff($sock);  
    printError("Konnte Create Table Query nicht executen!");  
    }
  
  // Die Tabelle wurde erfolgreich erstellt, wir geben jetzt noch die Resourcen
  // frei und informieren den Anwender das alles geklappt hat:

  OCIFreeStatement($stmt);
  echo("Tabelle ".$tname." wurde erfolgreich erstellt.");
  }

/*****************************************************************************
 * Und zu guter letzt noch die Verbindung zur Datenbank trennen. Auch das wrde
 * PHP alleine machen sobald das Script abgearbeitet ist.
 *****************************************************************************/

OCILogoff($sock);
?>
<br>
<p>
<br>
<a href="droptable_class.php">Table SCOTT_TEST lschen</a><br><br>
</body>
</html>
