<?php
/*****************************************************************************
 * Wir binden hier unseren Standard header ein, der alle weiteren Scripte einbindet
 * und das Cachen im Browser abschaltet.
 *****************************************************************************/
require_once("inc/nocache.inc.php");
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//DE" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="en">
<head>
<?php
/*****************************************************************************
 * Wir binden hier unsere Standard metatags ein
 *****************************************************************************/
require_once("inc/metadata.inc.php");
?>
</head>
<body>
<?php
/*****************************************************************************
 * Anzeige der Seiten Navigation (siehe nocache.inc.php fr Funktionsdefinition)
 *****************************************************************************/
printNavigation('Auflisten einer Tabelle','php_overview.php','createtable_oci.php','listtable_oci.php');

// Der Query zum Auflisten der Tabelle EMP:

$query = "SELECT EMPNO,ENAME,JOB,MGR,TO_CHAR(HIREDATE,'DD.MM.YYYY') AS HD,SAL,COMM,DEPTNO FROM EMP"
?>
Dieses Beispiel zeigt einen klassischen SELECT Query auf die Table EMP.<br>
Query: <?php echo($query);?><br>
<hr>
<pre>
EMPNO | ENAME           | JOB             | MGR   | HIREDATE   | SAL   | COMM  | DEPTNO
------+-----------------+-----------------+-------+------------+-------+-------+--------
<?php
/*****************************************************************************
 * Zuerst muss eine Datenbank Verbindung mit OCILogon() erstellt werden,
 * bei Erfolg gibt die Funktion ein Connection Handle zurck, sonst NULL im
 * Fehlerfall. Wenn eine Remote DB angesprochen werden soll muss als dritter
 * Parameter der TNS Name der DB angegeben werden, sonst wird zu ORACLE_SID
 * connected.
 *****************************************************************************/

$sock = OCILogon("scott","tiger");
if(!$sock)
  {
  echo("<font color=\"red\">Konnte keine Verbindung zur lokalen Datenbank aufbauen!?</font>\n");
  exit;  
  }

/*****************************************************************************
 * Die Verbindung steht jetzt, nun holen wir die Daten via SELECT. Dazu muss
 * zuerst unser Query "geparsed" werden, das erledigt die Funktion OCIParse().
 * Wenn alles klappt bekommen wir ein Statement handle zurck, das wir danach
 * an die weiteren Funktionen durchreichen mssen.
 * Im Fehlerfall wird die Datenbankverbindung getrennt und das Script beendet.
 *****************************************************************************/

$stmt = OCIParse($sock,$query);
if(!$stmt)
  {
  OCILogoff($sock);
  echo("<font color=\"red\">Konnte Query nicht parsen?</font>\n");
  exit;  
  }

/*****************************************************************************
 * Nach dem Parsen knnen wir jetzt die Daten von der DB "abholen", dazu wird
 * zuerst der geparste Query "Executed", und danach die einzelnen Datenstze
 * via OCIFetchInto() abgeholt bis alle Daten bertragen worden sind. OCIExecute()
 * erwartet als ersten Parameter ein gltiges Statement Handle und als zweiten
 * Parameter den Transaktions-Modus, der kann entweder OCI_COMMIT_ON_SUCCESS
 * (default, jedes DML Kommando wird sofort committed) oder OCI_DEFAULT (wir
 * mssen selber committen) sein.
 *****************************************************************************/

$retvar = OCIExecute($stmt,OCI_DEFAULT);
if(!$retvar)
  {
  OCIFreeStatement($stmt);
  OCILogoff($sock);
  echo("<font color=\"red\">Konnte Query nicht executen?</font>\n");
  exit;  
  }

/*****************************************************************************
 * OCIFetchInto() holt die nchste Row vom Statement handle $stmt ab und 
 * schreibt die Ergebnisse in das Array $retarray. ber den dritten Parameter
 * kann bestimmt werden wie die DAten abgeholt werden sollen. OCI_ASSOC oder OCI_NUM
 * bestimmen z.B. ob man assoziative oder numerische Arrays haben mchte. RETURN_NULLS
 * returniert auch Datenstze, die NULL enthalten und RETURN_LOBS wrde z.B. den
 * Inhalt von CLOB/BLOB Feldern zurckgeben anstatt den sonst blichen LOB-Locator.
 *****************************************************************************/

while(OCIFetchInto($stmt, $retarray, OCI_ASSOC+OCI_RETURN_NULLS+OCI_RETURN_LOBS))
  {
  printf("%5d | %-15s | %-15s | %5d | %s | %5d | %5d | %3d\n",
          $retarray['EMPNO'],
          $retarray['ENAME'],
          $retarray['JOB'],
          $retarray['MGR'],
          $retarray['HD'],
          $retarray['SAL'],
          $retarray['COMM'],
          $retarray['DEPTNO']);
  }

/*****************************************************************************
 * Wenn alle Daten ausgelesen worden sind sollte man noch das Statement handle
 * wieder freigeben. Diese Resourcen Freigaben macht PHP zwar am Ende des
 * Scriptes auch alleine, aber das ist kein guter Programmierstil, man sollte
 * IMMER alles zurckgeben was man sich vom System geholt hat! 
 *****************************************************************************/

OCIFreeStatement($stmt);

/*****************************************************************************
 * Und zu guter letzt noch die Verbindung zur Datenbank trennen. Auch das wrde
 * PHP alleine machen sobald das Script abgearbeitet ist.
 *****************************************************************************/

OCILogoff($sock);
?>
</pre>
<br>
</body>
</html>
