<?php
/*****************************************************************************
 * Wir binden hier unseren Standard header ein, der alle weiteren Scripte einbindet
 * und das Cachen im Browser abschaltet.
 *****************************************************************************/

require_once("inc/nocache.inc.php");

/*****************************************************************************
 * Da wir immer eine Fehlermeldung in roter Schrift ausgeben wollen, hier eine
 * Funktion, die einen Text ausgibt und das Script danach beendet. Funktionen
 * sollten immer am Anfang der Scripte stehen, am besten in eigenen Dateien und
 * dann per include() bzw. require() einbinden.
 *****************************************************************************/

function printError($txt)
  {
  echo("<font color=\"red\">".$txt."</font>\n</body>\n</html>\n");
  exit;  
  }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//DE" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="en">
<head>
<?php
/*****************************************************************************
 * Wir binden hier unsere Standard metatags ein
 *****************************************************************************/
require_once("inc/metadata.inc.php");
?>
</head>
<body>
<?php
/*****************************************************************************
 * Anzeige der Seiten Navigation (siehe nocache.inc.php fr Funktionsdefinition)
 *****************************************************************************/
printNavigation('Einf&uuml;gen von Daten in eine Tabelle','createtable_oci.php','procedure_oci.php','insertdata_oci.php');
?>
Ein Beispiel zur Verwendung von DML Kommandos, hier das INSERT Kommando.<br> 
Ausserdem wird gezeigt wie man Parameter an eine PHP Seite weiter reichen kann.<br>
<br>
<hr>
<form name="INSERTTEST" method="get" action="insertdata_oci.php">
<table>
<tr>
  <td>
  <fieldset><legend>Neue Daten eingeben:</legend>
  <table>
  <tr>
    <td>ID:</td>
    <td><input type="text" name="ID" value="" size="4"></td>
    <td>NAME:</td>
    <td><input type="text" name="NAME" value="" size="30"></td>
    <td><input type="submit" value="Speichern"></td>
  </tr>
  </table>
  </fieldset>
  </td>
</tr>
</table>
</form>
<hr>
<?php

// Datenbank Verbindung aufbauen:

if(!($sock = OCILogon("scott","tiger")))
  {
  printError("Konnte keine Datenbank Verbindung aufbauen?");
  }

/*****************************************************************************
 * Ob dieses Script als Submit Target aufgerufen wurde ist daran
 * zu erkennen das die Variablen $_GET['ID'] && $_GET['NAME'] definiert
 * sind. Normalerweise msste man hier jetzt natrlich die bergebenen
 * Daten prfen und auf eventuelle Exploits hin absichern (z.b. durch
 * stripslashes() o.. Funktionen). Man kann natrlich auch die Prfung
 * via Constraints auf Datenbank Ebene durchfhren, dann muss beim Speichern
 * der Daten logischerweise auf die Fehlercodes der Datenbank eingegangen werden.
 * Hier ist der bersicht halber keine berprfung eingebaut, alles wird 1:1
 * in die Tabelle geschrieben und nur auf generellen Erfolg der DB Operationen
 * geprft.
 *****************************************************************************/

if(!is_null($_GET['ID']) && !is_null($_GET['NAME']))  
  {
  // Wir haben Daten bekommen, also fhren wir jetzt ein Insert aus, 
  // wieder mit Bind Variablen:
  
  $query = "INSERT INTO SCOTT_TEST(ID,NAME) VALUES(:id,:name)";
  $stmt = OCIParse($sock,$query);
  if(!$stmt)
    {
    OCILogoff($sock);
    printError("Konnte INSERT Query nicht parsen?!");
    }
  
  // Wir haben jetzt das Statement handle, 
  // jetzt "binden" wir unsere Variablen:
  
  OCIBindByName($stmt,":id",$_GET['ID'],-1);
  OCIBindByName($stmt,":name",$_GET['NAME'],-1);
  
  // Nun noch das Statement ausfhren und bei Erfolg automatisch 
  // Commit() durchfhren lassen. Im Misserfolg wird mit OCIError()
  // die Fehlerbeschreibung ermittelt und mit ausgegeben.
  
  if(!OCIExecute($stmt,OCI_COMMIT_ON_SUCCESS))
    {
    $myerror = OCIError($stmt);
    OCIFreeStatement($stmt);
    OCILogoff($sock);
    $errorstring = "OCI-Errorcode: ".$myerror['code']."<br>OCI-Errortext: ".$myerror['message']."<br>";
    printError($errorstring."Konnte INSERT Query nicht ausfhren?!");
    }  
  }


// Anzeigen der vorhandenen Daten aus der Tabelle:

$listquery = "SELECT ID,NAME FROM SCOTT_TEST";
if(!($stmt = OCIParse($sock,$listquery)))
  {
  OCILogoff($sock);
  printError("Konnte SELECT query nicht parsen!");  
  }

/*****************************************************************************
 * Hier verwenden wir jetzt keine DEFINE Variablen, stattdessen wird jede 
 * Resultrow in ein Array gelesen. Da PHP eine Interpreter Sprache ist bedeuten 
 * weniger Befehle auch schnellere Abarbeitung, von daher ist OCIFetchInto() 
 * schneller als wenn man fr jedes returnierte Feld mit OCIDefineByName() eine 
 * Variable vorher angibt.
 * OCIFetchInto() erwartet als letzten Parameter eine Kombination von Flags, 
 * die das returnierte Ergebnis beeinflussen. Wir setzen hier OCI_ASSOC 
 * (assoziative Arrays anstatt numerisch) und OCI_RETURN_NULLS (returniert Rows 
 * mit NULL Werten). Weitere Flagdefinitionen knnen in der PHP Dokumentation 
 * nachgesehen werden.
 *****************************************************************************/

if(!OCIExecute($stmt,OCI_DEFAULT))
  {
  OCIFreeStatement($stmt);
  OCILogoff($sock);
  printError("Konnte SELECT query nicht ausfhren!");  
  }
$lv = 0;
echo("<table border=\"1\">\n<caption>Vorhandene Daten</caption>\n");
echo("<tr>\n");
echo("  <th>ID</th>\n");
echo("  <th>NAME</th>\n");
echo("</tr>\n");
while(OCIFetchInto($stmt,$returnarray, OCI_ASSOC+OCI_RETURN_NULLS))
  {
  echo("<tr>\n");
  echo("  <td>".$returnarray['ID']."</td>\n");
  echo("  <td>".$returnarray['NAME']."</td>\n");
  echo("</tr>\n");  
  $lv++;
  }
OCIFreeStatement($stmt);

// Wir prfen hier ab, ob berhaupt schon Daten angezeigt wurden. Wenn nicht
// geben wir eine kurze Info aus um den Nutzer zu informieren:

if(!$lv)
  {
  echo("<tr>\n");
  echo("  <td colspan=\"2\">Keine Daten in der Tabelle vorhanden.</td>\n");
  echo("</tr>\n");  
  }
echo("</table>\n");

// Und zu guter letzt DB Verbindung trennen:

OCILogoff($sock);
?>
</body>
</html>
