<?
require_once("inc/nocache.php");
$dbid=(int)$_GET["ID"];
if($dbid>MAXDB)
  {
  pError("Invalid DB ID given!",1);
  }
?>
<HTML LANG="en">
<HEAD>
  <TITLE>Oracle Information Site V<?echo($SITE_VER);?> - <?echo($ora_user[$dbid]."@".$ora_host[$dbid]);?></TITLE>
<?
require("inc/header.inc");
?>
</HEAD>        
<BODY BGCOLOR="#FFFFFF" LINK="#000000" VLINK="#000000">
<DIV ID="MAIN" ALIGN="CENTER">
<?
require("inc/title.inc");
?>
<SPAN CLASS="REDSUBTITLES">Oracle Instance Informations</SPAN><BR>
<BR>
<SPAN CLASS="TEXT"><A HREF="index2.php?ID=<?echo($dbid);?>">back to main menu</A></SPAN>
<P>
<?
flush();
$sock = @OCILogon($ora_user[$dbid],$ora_pass[$dbid],$ora_host[$dbid]);
if(!$sock)
  {
  oError($sock,"CONNECTING TO DATABASE FAILED:",1);
  }

/*
 ------------------------------------------------------------- 
             DB Block Buffer - Hit Ratio 
 ------------------------------------------------------------- 
*/

$myquery=<<<EOM
SELECT  (SELECT VALUE FROM V\$SYSSTAT WHERE NAME = 'db block gets') AS VAL1,
        (SELECT VALUE FROM V\$SYSSTAT WHERE NAME = 'consistent gets') AS VAL2,
        (SELECT VALUE FROM V\$SYSSTAT WHERE NAME = 'physical reads') AS VAL3
  FROM  DUAL
EOM;
if(!($stmt = @OCIParse($sock,$myquery)))
  {
  oError($sock,"PARSE(1):",1);
  }
@OCIDefineByName($stmt,"VAL1",$blockgets);
@OCIDefineByName($stmt,"VAL2",$consistentgets);
@OCIDefineByName($stmt,"VAL3",$physicalreads);
if(!@OCIExecute($stmt,OCI_DEFAULT))
  {
  oError($stmt,"EXECUTE(1):",0);
  @OCIFreeStatement($stmt);
  @OCILogoff($sock);
  exit;
  }
@OCIFetch($stmt);
@OCIFreeStatement($stmt);
$percent = sprintf("%2.2f",(100*(1-($physicalreads/($consistentgets+$blockgets)))));
?>
<TABLE CELLSPACING="1" CELLPADDING="2" BORDER="0">
<TR>
  <TD ALIGN="CENTER" COLSPAN="4"><SPAN CLASS="TEXT"><B>DB Block Buffer - Hit Ratio</B></SPAN></TD>
</TR>
<TR BGCOLOR="#FF0000">
  <TH><SPAN CLASS="portletTitle"><B>Physical Reads</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Consistent Gets</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>DB Block Gets</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Percent (Above 70% ?)</B></SPAN></TH>
</TR>
<TR BGCOLOR="#DDDDDD">
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo(number_format($physicalreads));?></SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo(number_format($consistentgets));?></SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo(number_format($blockgets));?></SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo($percent);?>%</SPAN></TD>
</TR>
</TABLE>
<?
flush();

/*
rem ------------------------------------------------------------- 
rem             Shared Pool Size - Gets and Misses 
rem ------------------------------------------------------------- 
*/

$myquery=<<<EOM
SELECT (SELECT SUM(pins) FROM V\$LIBRARYCACHE) AS VAL1, 
       (SELECT SUM(reloads) FROM V\$LIBRARYCACHE) AS VAL2, 
       (SELECT SUM(gets) FROM V\$ROWCACHE) AS VAL3, 
       (SELECT SUM(getmisses) FROM V\$ROWCACHE) AS VAL4 
  FROM DUAL
EOM;
$stmt = @OCIParse($sock,$myquery);
if(!$stmt)
  {
  PrintOraError();
  exit;
  }
@OCIDefineByName($stmt,"VAL1",$executions);
@OCIDefineByName($stmt,"VAL2",$cachemisses);
@OCIDefineByName($stmt,"VAL3",$ddg);
@OCIDefineByName($stmt,"VAL4",$gm);
if(!@OCIExecute($stmt,OCI_DEFAULT))
  {
  oError($stmt,"EXECUTE V\$DATABASE",0);
  @OCIFreeStatement($stmt);
  @OCILogoff($sock);
  exit;
  }
@OCIFetch($stmt);
@OCIFreeStatement($stmt);
$ratio = sprintf("%2.2f",($cachemisses/$executions*100)); 
$ratio2 = sprintf("%2.2f",100*($gm/$ddg)); 
?>
<BR>
<TABLE CELLSPACING="1" CELLPADDING="2" BORDER="0">
<TR>
  <TD ALIGN="CENTER" COLSPAN="7"><SPAN CLASS="TEXT"><B>Shared Pool Size - Gets and Misses</B></SPAN></TD>
</TR>
<TR BGCOLOR="#FF0000">
  <TH><SPAN CLASS="portletTitle"><B>Executions</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Cache misses<BR>executing</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>% Ratio<BR>(STAY UNDER 1%)</B></SPAN></TH>
  <TH BGCOLOR="#FFFFFF"><SPAN CLASS="portletTitle">&nbsp;</SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Data<BR>Dictionary Gets</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Get Misses</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>% Ratio<BR>(STAY UNDER 12%)</B></SPAN></TH>
</TR>
<TR BGCOLOR="#DDDDDD">
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo(number_format($executions));?></SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo(number_format($cachemisses));?></SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo($ratio);?></SPAN></TD>
  <TD BGCOLOR="#FFFFFF"><SPAN CLASS="TEXT">&nbsp;</SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo(number_format($ddg));?></SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo(number_format($gm));?></SPAN></TD>
  <TD ALIGN="CENTER"><SPAN CLASS="TEXT"><?echo($ratio2);?></SPAN></TD>
</TR>
</TABLE>
<BR>
<TABLE CELLSPACING="1" CELLPADDING="4" BORDER="0">
<TR>
  <TD ALIGN="CENTER" COLSPAN="9"><SPAN CLASS="TEXT"><B>Disc Activity by Tablespace Datafiles</B></SPAN></TD>
</TR>
<TR BGCOLOR="#FF0000">
  <TH><SPAN CLASS="portletTitle"><B>ID#</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Filename</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Physical<BR>Reads</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Physical<BR>Writes</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Block<BR>Reads</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Block<BR>Writes</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Read<BR>Time</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>Write<BR>Time</B></SPAN></TH>
  <TH><SPAN CLASS="portletTitle"><B>File<BR>Totals</B></SPAN></TH>
</TR>
<?
/*
 *  Disc Activity
 */
$myquery=<<<EOM
SELECT SUBSTR(df.file#,1,2) AS ID, 
       NAME AS FILENAME, 
       PHYRDS AS PHYREADS, 
       PHYWRTS AS PHYWRITES, 
       PHYBLKRD AS BLKREADS, 
       PHYBLKWRT AS BLKWRITES, 
       READTIM AS READTIME, 
       WRITETIM AS WRITETIME, 
       (SUM(PHYRDS+PHYWRTS+PHYBLKRD+PHYBLKWRT+READTIM)) AS FILETOTAL
  FROM V\$FILESTAT fs, V\$DATAFILE df 
 WHERE fs.file# = df.file# 
 GROUP BY df.file#, df.name, phyrds, phywrts, phyblkrd, phyblkwrt, readtim, writetim 
 ORDER BY SUM(PHYRDS+PHYWRTS+PHYBLKRD+PHYBLKWRT+READTIM) DESC, df.name 
EOM;
$stmt = @OCIParse($sock,$myquery);
@OCIDefineByName($stmt,"ID",$id);
@OCIDefineByName($stmt,"FILENAME",$filename);
@OCIDefineByName($stmt,"PHYREADS",$pread);
@OCIDefineByName($stmt,"PHYWRITES",$pwrite);
@OCIDefineByName($stmt,"BLKREADS",$bread);
@OCIDefineByName($stmt,"BLKWRITES",$bwrite);
@OCIDefineByName($stmt,"READTIME",$rtime);
@OCIDefineByName($stmt,"WRITETIME",$wtime);
@OCIDefineByName($stmt,"FILETOTAL",$filetotal);
if(!@OCIExecute($stmt,OCI_DEFAULT))
  {
  oError($stmt,"EXECUTE V\$DATABASE",0);
  @OCIFreeStatement($stmt);
  @OCILogoff($sock);
  exit;
  }
$lv = 0;
while(OCIFetch($stmt))
  {
  if($lv % 2) $myback = "#BBBBBB";
  else $myback = "#DDDDDD";
  echo("<TR BGCOLOR=\"".$myback."\">\n");
  echo("  <TD ALIGN=\"CENTER\"><SPAN CLASS=\"TEXT\">".$id."</TD>\n");
  echo("  <TD ALIGN=\"LEFT\"><SPAN CLASS=\"SMALL\">".$filename."</TD>\n");
  echo("  <TD ALIGN=\"RIGHT\"><SPAN CLASS=\"TEXT\">".number_format($pread)."</TD>\n");
  echo("  <TD ALIGN=\"RIGHT\"><SPAN CLASS=\"TEXT\">".number_format($pwrite)."</TD>\n");
  echo("  <TD ALIGN=\"RIGHT\"><SPAN CLASS=\"TEXT\">".number_format($bread)."</TD>\n");
  echo("  <TD ALIGN=\"RIGHT\"><SPAN CLASS=\"TEXT\">".number_format($bwrite)."</TD>\n");
  echo("  <TD ALIGN=\"RIGHT\"><SPAN CLASS=\"TEXT\">".number_format($rtime)."</TD>\n");
  echo("  <TD ALIGN=\"RIGHT\"><SPAN CLASS=\"TEXT\">".number_format($wtime)."</TD>\n");
  echo("  <TD ALIGN=\"RIGHT\"><SPAN CLASS=\"TEXT\">".number_format($filetotal)."</TD>\n");
  echo("</TR>\n");
  $lv++;
  }
echo("</TABLE>\n");
@OCIFreeStatement($stmt);
@OCILogoff($sock);
?>
<P>
<HR SIZE="1">
<A HREF="index2.php?ID=<?echo($dbid);?>" CLASS="TEXT">back to main menu</A>&nbsp;|&nbsp;<A HREF="#MAIN" CLASS="TEXT">Top</A>
</DIV>
<?
printFooter();
?>
</BODY>
</HTML>
