<?php
/*****************************************************************************
 * Wir binden hier unseren Standard header ein, der alle weiteren Scripte einbindet
 * und das Cachen im Browser abschaltet.
 *****************************************************************************/
require_once("inc/nocache.inc.php");

// Und die obligatorische Error Anzeige Funktion,diesmal aber mit Erweiterung
// um auch DB Connection und eventuelles Statement freizugeben und vorher
// einen ggf. vorhandenen DB Error auszulesen und mit anzuzeigen:

function printError($txt, $dbsock = NULL, $dbstmt = NULL)
  {
  echo("<font color=\"red\">".$txt."</font>\n");
  if(!is_null($dbstmt))
    {
    $myerror = OCIError($dbstmt);
    }
  elseif(!is_null($dbsock))
    {
    $myerror = OCIError($dbsock);
    }  
  else $myerror = NULL;  
  if(is_Array($myerror))
    {
    printf("<br>\nOCI-ERRORCODE: %s<br>OCI-ERRORTEXT: %s<br>\n",$myerror['code'],$myerror['message']);
    }
  echo("</body>\n</html>\n");
  if(!is_null($dbstmt)) OCIFreeStatement($dbstmt);
  if(!is_null($dbsock)) OCILogoff($dbstmt);
  exit;  
  }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//DE" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="en">
<head>
<?php
/*****************************************************************************
 * Wir binden hier unsere Standard metatags ein
 *****************************************************************************/
require_once("inc/metadata.inc.php");
?>
</head>
<body>
<?php
/*****************************************************************************
 * Anzeige der Seiten Navigation (siehe nocache.inc.php fr Funktionsdefinition)
 * Hier verwenden wir jetzt auch nicht mehr den Seitennamen als statischen
 * String (letzter Parameter von printNavigation()) sondern ermitteln diesen aus
 * der $_SERVER[] Variablen. Die basename() Funktion returniert dann nur noch
 * den Filenamen des aktuellen PHP Scripts ohne den kompletten Pfad.
 *****************************************************************************/
printNavigation('Aufruf einer Prozedur mit IN/OUT Variablen','insertdata_oci.php','droptable_class.php',basename($_SERVER['SCRIPT_FILENAME']));
?>
<br>
Hier wird eine Prozedur aufgerufen, die eine &uuml;bergebene Zahl mit 2 multipliziert<br>
und in die OUT Variable das Ergebnis zurck schreibt.<br>
Die Prozedur ist sehr simpel gestrickt:<br>
<pre>
CREATE OR REPLACE PROCEDURE DoSomething(p_orgvar IN NUMBER, p_newvar OUT NUMBER)
IS
BEGIN
 p_newvar:=p_orgvar * 2;
END;
</pre>
<br>
<hr>
<form name="PROCTEST" method="get" action="procedure_oci.php">
<table>
<tr>
  <td>
  <fieldset><legend>Take 2:</legend>
  <table>
  <tr>
    <td>Wert:</td>
    <td><input type="text" name="VAL" value="" size="4"></td>
    <td><input type="submit" value="Abschicken"></td>
  </tr>
  </table>
  </fieldset>
  </td>
</tr>
</table>
</form>
<hr>
<?
/*****************************************************************************
 * Hier prfen wir jetzt erstmal, ob wir einen Wert haben. Wenn das nicht
 * der Fall ist schreiben wir die notwendigen HTML Abschluss Befehle und
 * terminieren das Skript hier. Das macht die nachfolgenden Aktionen bersichtlicher
 *****************************************************************************/

if(is_null($_GET['VAL']) || $_GET['VAL'] == "")
  {
  echo("Bitte einen Wert eingeben, der mit 2 multipliziert werden soll.<br>");
  echo("</body>\n</html>\n");
  exit;  
  }

// Wert ist da, let's start the dance:

if(!($sock = OCILogon("SCOTT","TIGER")))
  {
  printError("Konnte keine Datenbank Verbindung aufbauen?");
  }

// Der Query fr den Aufruf der Prozedur, wieder mit Bind Variablen:

$query = "BEGIN DoSomething(:invar,:outvar); END;";

if(!($stmt = OCIParse($sock,$query)))
  {
  printError("Konnte Prozedur Aufruf nicht parsen?",$sock,NULL);
  exit;  
  }

/*****************************************************************************
 * Nun mssen wir die Binds machen. Zuerst der Bind fr die IN Variable,also
 * die bergebene Variable:
 *****************************************************************************/

OCIBindByName($stmt,":invar",$_GET['VAL'],-1);

/*****************************************************************************
 * Achtung! Da wir eine OUT Variable deklarieren, muss PHP mitgeteilt werden, 
 * welche Grsse die Variable haben soll. Dabei ist darauf zu achten das in 
 * Characters gerechnet werden muss. Da Oracle sehr grosse Zahlen verarbeiten 
 * kann (max. 125 Stellen!) sollte man auch auf sowas vorbereitet sein. Hier 
 * wird nicht die Wertigkeit des Datentypes sondern die Lnge des Ergebnisses 
 * in Bytes angeben!
 *****************************************************************************/

$myoutvar = 0;
OCIBindByName($stmt,":outvar",$myoutvar,125);

// Procedure aufrufen:

if(!OCIExecute($stmt,OCI_DEFAULT))
  {
  printError("Konnte Prozedur nicht aufrufen?",$sock,$stmt);
  }

// Das Ergebnis steht jetzt in der Variablen $myoutvar:

echo("Das Ergebnis: ".$_GET['VAL']." * 2 = ".$myoutvar."<br>\n");

// Und wieder alles zurck geben was man sich genommen hat:

OCIFreeStatement($stmt);
OCILogoff($sock);
?>
</body>
</html>
